/*======================================================*/
/*      Copyright NCSA                                  */
/*======================================================*/

#define MCCI_MAX_RETURN_TEXT	1024


/* return codes from cci api */
#define MCCI_OK			0
#define MCCI_FAIL		1
#define MCCI_OUTOFMEMORY	2
#define MCCI_REQUEST_FAIL	3
#define MCCI_NETWORK_ERROR	4

/* internal defines */
#define MCCI_DEFAULT		0
#define MCCI_OUTPUT_NONE	100
#define MCCI_OUTPUT_CURRENT	101
#define MCCI_OUTPUT_NEW		102
#define MCCI_ABSOLUTE		110
#define MCCI_RELATIVE		111

#define MCCI_SEND_BEFORE	210
#define MCCI_SEND_AFTER		220

/* protocol token strings */
#define MCCI_S_GET		"GET"
#define MCCI_S_DISPLAY		"DISPLAY"
#define MCCI_S_DISCONNECT	"DISCONNECT"
#define MCCI_S_QUIT		"QUIT"
#define MCCI_S_SEND		"SEND"
#define MCCI_S_OUTPUT		"OUTPUT"
#define MCCI_S_ANCHOR		"ANCHOR" 
#define MCCI_S_BEFORE		"BEFORE"
#define MCCI_S_AFTER		"AFTER"
#define MCCI_S_BROWSERVIEW	"BROWSERVIEW"

#define MCCI_S_TO		"TO"
#define MCCI_S_STOP		"STOP"
#define MCCI_S_CURRENT		"CURRENT"
#define MCCI_S_NEW		"NEW"
#define MCCI_S_NONE		"NONE"
#define MCCI_S_HEADER		"HEADER"
#define MCCI_S_POST		"POST"


/* successful return codes in protocol*/
#define MCCIR_OK			200
#define MCCIR_GET_OK			210
#define MCCIR_DISPLAY_OK		211
#define MCCIR_DISCONNECT_OK		212
#define MCCIR_QUIT_OK			213
#define MCCIR_SEND_OUTPUT_OK		214
#define MCCIR_SEND_O_STOP_OK		215
#define MCCIR_SEND_ANCHOR_OK		216
#define MCCIR_SEND_A_STOP_OK		217
#define MCCIR_POST_OK			218
#define MCCIR_BROWSERVIEW_OK		219
#define MCCIR_BROWSERVIEW_STOP_OK	220

/* Send Anchor Before return codes */
#define MCCIR_SEND_ANCH_BEF_LINK_OK	280  /* clicked link  */
#define MCCIR_SEND_ANCH_BEF_OPEN_OK	281  /* used open dialog */
#define MCCIR_SEND_ANCH_BEF_EDIT_OK	282  /* edited URL field  */
#define MCCIR_SEND_ANCH_BEF_FORW_OK	283  /* clicked forward */
#define MCCIR_SEND_ANCH_BEF_BACK_OK	284  /* clicked back */
#define MCCIR_SEND_ANCH_BEF_RELO_OK	285  /* clicked reload */
#define MCCIR_SEND_ANCH_BEF_HIST_OK	286  /* from history  */
#define MCCIR_SEND_ANCH_BEF_HOTL_OK	287  /* from hotlist */
#define MCCIR_SEND_ANCH_BEF_MCCI_OK	288  /* from CCI */
#define MCCIR_SEND_ANCH_BEF_OTHR_OK	289  /* from other source */      

/* sendAnchor After return codes */
#define MCCIR_SEND_ANCH_AFT_LINK_OK	290  /* clicked link  */          
#define MCCIR_SEND_ANCH_AFT_OPEN_OK	291  /* used open dialog */       
#define MCCIR_SEND_ANCH_AFT_EDIT_OK	292  /* edited URL field  */      
#define MCCIR_SEND_ANCH_AFT_FORW_OK	293  /* clicked forward */        
#define MCCIR_SEND_ANCH_AFT_BACK_OK	294  /* clicked back */           
#define MCCIR_SEND_ANCH_AFT_RELO_OK	295  /* clicked reload */         
#define MCCIR_SEND_ANCH_AFT_HIST_OK	296  /* from history  */          
#define MCCIR_SEND_ANCH_AFT_HOTL_OK	297  /* from hotlist */           
#define MCCIR_SEND_ANCH_AFT_MCCI_OK	298  /* from CCI */               
#define MCCIR_SEND_ANCH_AFT_OTHR_OK	299  /* from other source */      


/* additional data follows repsonse code */
#define MCCIR_ANCHOR_INFO	301 /* anchor visited information */
#define MCCIR_SEND_DATA_OUTPUT	302 /* output from Send Output protocol */
#define MCCIR_SEND_BROWSERVIEW	303 /* output from Send Browserview proto */
#define MCCIR_POST_OUTPUT	304 /* output from post */

/* problem response codes... client problems*/
#define MCCIR_UNRECOGNIZED	401  /* what's this? */
#define MCCIR_ERROR		402  /* does not follow protocol */

/* problem response codes... broswer problems*/
#define MCCIR_REQ_FAILED	500  /* request failed */
#define MCCIR_GET_FAILED	501  /* request failed */


#include "port.h"
typedef PortDescriptor *MCCIPort;

