#include <string.h>
#include "memStuffForPipSqueeks.h"
#include "cci.h"
#include "connect.h"
#include "list.h"

#define DEBUG

static int initialized = 0;
static List anchorCBList = 0;
static List outputCBList = 0;
static List browserViewCBList = 0;

extern char *GetLine();

typedef struct {
		MCCIPort serverPort;
		void (*callBack)();
		void *callBackData;
		} AnchorCallBack;

typedef struct {
		MCCIPort serverPort;
		char *type;
		void (*callBack)();
		void *callBackData;
		} OutputCallBack;

typedef struct {
		MCCIPort serverPort;
		void (*callBack)();
		void *callBackData;
		} BrowserViewCallBack;

int MCCIGetSocketDescriptor(serverPort)
/* this routine is platform dependent and is not assumed to be supported
 * on all platforms.  It is only here for those routines that wish to have
 * a select() external to the MCCI library.
 * this routine extracts the socket descriptor from the MCCIPort and
 * returns it */
MCCIPort serverPort;
{
	return(NetGetSocketDescriptor(serverPort));
}


int MCCIPoll(serverPort)
/* this routine is intended to be called periodically to check for input
 * from the server.  If so, it's handled.
 * return -1 on Not connected.
 * return 1 if something was read.
 * return 0 on nothing here.
 */
MCCIPort serverPort;
{
char *line;
int ret=0;

	if (!MCCIIsConnected(serverPort)) {
		return(-1);
		}

	while (MCCIIsThereInput(serverPort)) {
		line = GetLine(serverPort);
		if (!line) {
			/* server has disconnected */
			MCCIDisconnect(serverPort);
			}
		MCCIHandleAddOutput(serverPort,line);
		ret = 1;
		}

	if (!MCCIIsConnected(serverPort)) {
		return(-1);
		}
	else {
		return(ret);
		}
}


int MCCINBGet(serverPort,uri,output,absRelative,additionalHeader)
/***************************************************************************
* MCCIGet - Resolve a URL 
*	uri - the URL to be resolved 	
*	output - where should the output go?
*		MCCI_DEFAULT		- same as OUTPUT_CURRENT
*		MCCI_OUTPUT_NONE	- Browser shouldn't display
*		MCCI_OUTPUT_CURRENT     - Browser should display in current
*		MCCI_OUTPUT_NEW		- Browser should display in new window
* 	absRelative - url should be treated as either a relative or
*		or absolute link to the current document 
*		MCCI_DEFAULT		- set to absolute
*		MCCI_ABSOLUTE
*		MCCI_RELATIVE
*	additionalHeader - This is a string containing additional HTTP
*		header information to pass to the server.  If this is
*		a standard HTTP GET, this field should be set to NULL.
* Example:
*	MCCINBGet(port,"http://host/file",0,MCCI_ABSOLUTE,0);
***************************************************************************/
MCCIPort serverPort;
char *uri; 
int output;
int absRelative;
char *additionalHeader;
{
char *buff;
char buff2[80];
int length,lengthToSend;
char *line;
int approxSize;

	if (!serverPort) {
		return(MCCI_FAIL);
		}

	if (!MCCIIsConnected(serverPort)) {
		return(MCCI_NETWORK_ERROR);
		}

	approxSize = 256;
	if (!uri) {
		/* required parameter */
		return(MCCI_FAIL);
		}
	else {
		approxSize += strlen(uri);
		}
	if (additionalHeader) {
		approxSize += strlen(additionalHeader);
		}

	if (!(buff = (char *) MALLOC(approxSize))) {
		/* memory problems */
		return(MCCI_OUTOFMEMORY);
		}

	sprintf(buff,"GET URL <%s>",uri);
	switch (output) {
		case MCCI_OUTPUT_NONE:	
				strcat(buff," OUTPUT NONE");
				break;
		case MCCI_OUTPUT_NEW:	
				strcat(buff," OUTPUT NEW");
				break;
		case MCCI_OUTPUT_CURRENT:	
		default: 
				strcat(buff," OUTPUT CURRENT");
				break;
		}
/*
	switch (absRelative) {
		case MCCI_RELATIVE:
				strcat(buff," RELATIVE");
				break;
		case MCCI_ABSOLUTE:
		default:
				strcat(buff," ABSOLUTE");
				break;
		}
*/
	if (additionalHeader) {
		strcat(buff," HEADER\r\n");
		sprintf(buff2,"Content-Length: %d\r\n",
				strlen(additionalHeader));
		strcat(buff,buff2);
		strcat(buff,additionalHeader);
		}
	else {
		strcat(buff,"\r\n");
		}

	lengthToSend = strlen(buff);
	length = MCCIWrite(serverPort, buff, lengthToSend);
	FREE(buff);

	if (length != lengthToSend) {
		/* error sending */
		return(MCCI_FAIL);
		}

	return(MCCI_OK);
}

int MCCIPost(serverPort,url,contentType,data,dataLength,output)
/***************************************************************************
* MCCIPost- Post data to an HTTP server
*       url - the URL to be resolved
* 	contentType: MIME type for data
*	data - the data  to be posted to the HTTP server
*	dataLength - Length of the above data
*       output - where should the output go?
*               MCCI_DEFAULT            - same as OUTPUT_CURRENT
*               MCCI_OUTPUT_NONE        - Browser shouldn't display
*               MCCI_OUTPUT_CURRENT     - Browser should display in current
*               MCCI_OUTPUT_NEW         - Browser should display in new window
*/
MCCIPort serverPort;
char *url; 
char *contentType;
char *data;
int dataLength;
int output;
{
char *line;
char *buff;
int lengthToSend;
int length;

	if (!serverPort) {
		return(MCCI_FAIL);
		}
	if (!MCCIIsConnected(serverPort)) {
		return(MCCI_NETWORK_ERROR);
		}

	if (!(buff = (char *) MALLOC(strlen(url) + 256))) {
		return(MCCI_OUTOFMEMORY);
		}

	sprintf(buff, "%s <%s> %s", MCCI_S_POST, url, contentType);
	switch(output) {
		case MCCI_OUTPUT_NEW:
			strcat(buff," OUTPUT NEW");
			break;
		case MCCI_OUTPUT_NONE:
			strcat(buff," OUTPUT NONE");
			break;
		case MCCI_OUTPUT_CURRENT:
		case MCCI_DEFAULT:
			strcat(buff," OUTPUT CURRENT");
			break;
		}
	strcat(buff,"\r\n");

	lengthToSend = strlen(buff);
	length = MCCIWrite(serverPort, buff, lengthToSend);
	if (length != lengthToSend) {
		return(MCCI_FAIL);
		}
#ifdef DEBUG
	printf("Post Request: %s",buff);
#endif

	sprintf(buff, "Content-Length: %d \r\n",dataLength);
	lengthToSend = strlen(buff);
	length = MCCIWrite(serverPort, buff, lengthToSend);
	if (length != lengthToSend) {
		return(MCCI_FAIL);
		}

	length = MCCIWrite(serverPort, data, dataLength);
	if (length != dataLength) {
		return(MCCI_FAIL);
		}
#ifdef DEBUG
	printf("%s%s\n",buff,data);
#endif
	/* get server response */
	line = MCCIGetResponse(serverPort);

#ifdef DEBUG
	printf("POST reply: %s\n",line);
#endif
	free(buff);

	if (!line) {
		return(MCCI_NETWORK_ERROR);
		}
	if (line[0]=='2') {
		return(MCCI_OK);
		}
	else {
		return(MCCI_REQUEST_FAIL);
		}
} /* MCCIPost() */



