%	solve.pl, Shaky v1.0
%	Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp)

/* solve(Query,Answer):-
	QueryФyes, noѿΥХɤ֤ */
% solve(Goal)
solver([Sit,Inf,St],Out):-
	var(Sit),
	db:domain(All_s),
	solve([[Sit,Inf,St]],[[Sit,[nil,nil,[],All_s]]],Out_raw),!,
	output(Out_raw,Out).
solver([Sit,Inf,St],Out):-
	ground(Sit),
	user:nth(1,Sit,First),user:last(Sit,Last),
	solve([[Sit,Inf,St]],[[Sit,[First,Last,Sit,Sit]]],Out_raw),!,
	output(Out_raw,Out).

get_range(X,[First,Last,X,X]):-
	ground(X),
	user:nth(1,X,First),user:last(X,Last).

/* solve(Goals,In,Out):- ʣGoalsФƤξ */
solve([],_,[]):-!.
solve([G|Goal],In,Out):-
	[Sit,Inf,St]=G,
	get_in1(Sit,In,In_g),
	solve_s(G,In_g,Out_g),
	solve(Goal,In,Out_goal),
	merge_sl(Out_g,Out_goal,Out).

/* solve_s(Goal,In,Out):- 1ĤGoalФƤξ */
solve_s([Sit,Inf,0],[Sit,[F,L,N,R]],[Sit,[F,L,N,Res]]):-
	solve_e(R,Inf,Res),!,
	Res\==[],
	u:subset(N,Res).
/*
solve_s([Sit,Inf,0],In,Out):-
	solve_r([Sit,Inf,0],In,Out,S).

solve_s([Sit,Inf,1],[Sit,[F,L,N,R]],[Sit,[F,L,N,Res]]):-
	solve_e1(R,Inf,Res),
	u:subset(N,Res).
solve_s([Sit,Inf,1],In,Out):-
	solve_r([Sit,Inf,0],In,Out,S).

solve_e01([E|R],Inf,[E|Res]):-
	db:support1(X,Inf)
	solve_e01(
solve_s([Sit,Inf,2],[Sit,[F,L,N,R]],[Sit,[F,L,N,Res]]):-
	solve_e(R,Inf,Res),
	u:subset(N,Res).
solve_s([Sit,Inf,2],In,Out):-
	solve_r([Sit,Inf,0],In,Out,S).
*/

/* solve_e(Range,Inf,RR) :- 
  եInfΩäƤ뤫RangeĴ٤ */
solve_e([],_,[]):-!.
solve_e([E|R],Inf,[E|Res]):-
	solve_e1(E,Inf),
	solve_e(R,Inf,Res).
solve_e([E|R],Inf,Res):-
	solve_e(R,Inf,Res).
solve_e1(E,Inf):-
	db:support0(E,Inf),
	u:dual(Inf,Inf_dual),
	\+db:support0(E,Inf_dual).
solve_e1(E,Inf):-
	solve_r([[E],Inf,0],[[E],[E,E,[E],[E]]],_,S),
	u:dual(Inf,Inf_dual),
	db:support0(E,Inf_dual),!,fail.
solve_e1(E,Inf):-
	solve_r([[E],Inf,0],[[E],[E,E,[E],[E]]],_,S),
	u:dual(Inf,Inf_dual),
	solve_r([[E],Inf_dual,0],[[E],[E,E,[E],[E]]],_,S_dual),!,
	db:stronger(S,S_dual).
solve_e1(E,Inf):-
	solve_r([[E],Inf,0],[[E],[E,E,[E],[E]]],_,S).

/* solve_r(Goal,In,Out):- 롼뤫Goal褹 */
solve_r(Goal,In,Out,E):-
	db:rs(E),
	db:get_data(sr,E,Ids),
	user:member(Id,Ids),
	db:rule(Id,[Head,Body,BC]),
	unify(Goal,Head),
	sv(Body,VL_body),
	cs_in(In,VL_body,BC,In_body),
	solve(Body,In_body,Out_raw),
	cs_out(Out_raw,BC,Out),
	disp(Head,Body,Out),!.


disp(Head,Body,Out):-!,
	sv([Head],[]),
	tr:transfer_itoe([term,Head],Hex),
	name(X,Hex),
	format("~k<-\n",[X]),
	disp1(Body,Out).
disp(Head,Body,Out):-
	sv([Head],[Vhead]),
	get_in1(Vhead,Out,X),
	[_,[_,_,N,N]]=X,
	user:substitute(Vhead,Head,N,H),
	tr:transfer_itoe([term,H],Hex),
	name(X,Hex),
	format("~k<-\n",[X]),
	disp1(Body,Out).
disp1([],_).
disp1([B|Body],Out):-
	sv([B],[]),
	tr:transfer_itoe([term,B],Bex),
	name(X,Bex),
	format("   ~k\n",[X]),
	disp1(Body,Out).
disp1([B|Body],Out):-
	sv([B],[Vb]),
	get_in1(Vb,Out,X),
	[_,[_,_,N,N]]=X,
	user:substitute(Vb,B,N,BB),
	tr:transfer_itoe([term,BB],Bex),
	name(Y,Bex),
	format("   ~k\n",[Y]),
	disp1(Body,Out).

bind([],_).
bind([E|VL],Out):-
	get_in1(E,Out,X),
	[_,[_,_,N,N]]=X,
	E=N,
	bind(VL,Out).
bind([_|VL],Out):-
	bind(VL,Out).

cs_out(In,[],In).
cs_out(In,[[Rel,Args,_]|BC],Out):-
	C=..[Rel,Args,In,Res],
	cs_out:C,
	merge_sll(In,Res,Inn),
	cs_out(Inn,BC,Out).


/*
cs_out(Out_raw,Out).
*/

get_sit(Range,[First|S]):-
	user:member(First,Range),
	get_sit1(Range,First,S).
get_sit1(Range,E,[Next|S]):-
	db:link(E,Next),user:member(Next,Range),
	get_sit1(Range,Next,S).
get_sit1(Range,E,[]):-
	db:link(E,nil).

first([],[]).
first([E|Range],[E|FL]):-
	\+db:link(_,E),
	first(Range,FL).
first([E|Range],FL):-
	first(Range,FL).

/* cs_in(In,VL_body,BC,In_body):-
    InꥹȤѿVL_bodyطʾBCIn_body */
cs_in(In,VL_body,BC,In_body):-!,
	cs_in(In,BC,R),
	sv(R,RV),
	u:sabun(VL_body,RV,V),
	vl_add(V,R,In_body).
cs_in(In,[],[In]):-!.
cs_in(In,[[Rel,Args,_]|BC],R):-
	C=..[Rel,Args,Res],
	cs:C,!,
	merge_sl(In,Res,Inn),
	cs_in1(Inn,BC,R).
cs_in1(Inn,[],Inn).
cs_in1(Inn,[[Rel,Args,_]|BC],R):-
	C=..[Rel,Args,Res],
	cs:C,!,
	merge_sll(Inn,Res,Inn1),
	cs_in1(Inn,BC,R).
vl_add([],R,R):-!.
vl_add([E|V],R,[[E,[nil,nil,[],X]]|In]):-
	db:get_domain([nil,nil,[]],X),
	vl_add(V,R,In).

/* 󥸽Υޡ */
merge_sll([],Res,Res).
merge_sll([E|S],Res,Inn1):-
	merge_sl(E,Res,Res1),
	merge_sll(S,Res1,Inn1).
merge_sl(S,[],[S]).
merge_sl([Sit,Range],[[S,Ra]|SL],[[Sit,Res]|SL]):-
	Sit==S,merge_range(Range,Ra,Res).
merge_sl(S,[E|SL],[E|R]):-
	merge_sl(S,SL,R).

/* 󥸤Υޡ */
merge_range([F1,L1,N1,R1],[F2,L2,N2,R2],[F3,L3,N3,R3]):-
	merge_range_f(F1,F2,F3),
	merge_range_l(L1,L2,L3),
	merge_range_n(N1,N2,N3),
	merge_range_r(R1,R2,R3),
	u:subset(N3,R3).
merge_range_f(nil,F2,F3):-
	F3=F2.
merge_range_f(F1,nil,F3):-
	F3=F1.
merge_range_l(nil,L2,L3):-
	L3=L2.
merge_range_l(L1,nil,L3):-
	L3=L1.
merge_range_n(N1,N2,N3):-
	u:union([N1,N2],N3).
merge_range_r(R1,R2,R3):-
	u:intersection([R1,R2],R3).

/* sv(LL,VL):- LLKeyȤʤѿνVL */
sv([],[]).
sv([[S|_]|L],[S|VL]):-
	var(S),
	sv(L,VL).
sv([[S|_]|L],VL):-
	nonvar(S),
	sv(L,VL).
/* get_in(Sit,SL,S,L):- SitΥSȻĤL֤ */
get_in1(Sit,[[S,Range]|L],[S,Range]):-
	Sit == S.
get_in1(Sit,[[S,Range]|L],In):-
	Sit \== S,
	get_in1(Sit,L,In).
/*
get_in(Sit,[[S,Range]|L],[S,Range],L):-
	Sit == S.
get_in(Sit,[X|VL],In,[X|L]):-
	get_in(Sit,VL,In,L).
*/

/* output(Out_raw,Out) :- Υ󥸤θ֤ */
output([],[]).
output([E|Out_raw],[S|Out]):-
	situation(E,S),
	output(Out_raw,Out).
output([E|Out_raw],Out):-
	output(Out_raw,Out).

situation([Sit,[F,L,N,R]],_):-
	ground(Sit),!,fail.
situation([Sit,[F,L,N,R]],[Sit,S]):-
	get_sit(R,S),
	firstp(F,S),
	lastp(L,S),
	u:subset(N,S).
firstp(nil,S).
firstp(F,[F|S]).
lastp(nil,S).
lastp(L,S):-
	user:last(L,S).
