%  Shaky v1.0      Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp) 
/* ǡ١⥸塼 */
:- module(db,[]).

/* newdb :- ǡ١ν 
    as_list : Υꥹ
    support_map0,1,2 : ݡȥޥå 
        0 : non persistent
        1 : persistent
        2 : equal
*/
newdb :-
	bb_put(i_id,0),
	bb_put(r_id,0),
	newdb([links,infons,support_map0,support_map1,support_map2,
	rules,domain,s_link,sr,str_order]).
newdb([]).
newdb([DB|DBL]):-
	del_db(DB),
	X=..[DB,[]], 
	asserta(X),
	newdb(DBL).

/* ǡ١DB¸ߤʤä. ʤФʤˤ⤷ʤ. */
del_db(DB):-
	current_predicate(DB,_),
	abolish(DB,1).
del_db(DB).

/* Υ */
% s_link([[s1,[s2,s3]],[s2,[s4]],[s3,[s4]],[s4,[s5]]]).
% domain([s1,s2,s3,s4]).

/* ǡǡ١˥ȥ */
store_data([term, X]):-
	store_term(X).
store_data([rule, X]):-
	store_rule(X).
store_data([infon, X]):-
	store_term([[w],X,0]).

/* ִطǡ١˥ȥ */
store_sr_data([infon, [domain,[[dom,X]],1]]):-
	del_db(domain),
	asserta(domain(X)).
store_sr_data([infon, [link, [[from,X],[to,Y]],1]]):-
	update_slink(X,Y).
store_sr_data([infon, [str,[[order,X]],1]]):-
	str_order(Z),
	del_db(str_order),
	asserta(str_order(X)).
store_sr_data([infon, INF]):-
	store_term([[w],INF,0]).

/* update_slink(X,Y) :- 
    XY˥󥯤ĥƤ뤳Ȥ򥹥ȥ */
update_slink(X,Y):-
	s_link(L),
	update_slink(L,X,Y,LL),
	del_db(s_link),
	asserta(s_link(LL)).
update_slink([],X,Y,[[X,[Y]]]).
update_slink([[X,Lx]|L],X,Y,[[X,Lx]|L]):-
	user:member(Y,Lx).
update_slink([[X,Lx]|L],X,Y,[[X,[Y|Lx]]|L]).
update_slink([E|L],X,Y,[E|LL]):-
	update_slink(L,X,Y,LL).

/* ζ */
stronger(X,Y):-
	str_order(Str),
	user:nth(Nx,Str,X),
	user:nth(Ny,Str,Y),
	Nx < Ny.

/* store_rule(X) :- 롼ǡ١˲ä */
store_rule([E,Rule]):-
	rules(Rules),
	new_id(r_id,Id),
	del_db(rules),
	asserta(rules([[Id,Rule]|Rules])),
	store_sr(E,Id).
store_sr(E,Id):-
	sr(SM),
	store_sr(SM,E,Id,SM_new),
	del_db(sr),
	asserta(sr(SM_new)).
store_sr([],E,Id,[[E,[Id]]]).
store_sr([[E,X]|SM],E,Id,[[E,[Id|X]]|SM]).
store_sr([X|SM],E,Id,[X|SM_new]):-
	store_sr(SM,E,Id,SM_new).

/* store_term(X) :- ǡ١˲ä */
store_term([Sit,Inf,St]):-
	store_infon(Inf,Id),
	store_sm(Sit,Id,St).

/* store_infon(Inf,I_id) :- infoninfons list˲ä, id */
store_infon(Inf,I_id):-
	infons(Infs),
	check_member(Inf,Infs,Id),
	store_infon1(Inf,Infs,Id,I_id,New_infs),
	del_db(infons),
	asserta(infons(New_infs)).
store_infon1(Inf,Infs,-1,I_id,[[I_id,Inf]|Infs]):-
	new_id(i_id,I_id).
store_infon1(_,Infs,Id,Id,Infs).

/* store_sm(Sit,Id,Stype) :- Sitid=IdΥե
   ݡȴطStypeǤ뤳Ȥǡ١˲ä */
store_sm(Sit,Id,0):-
	support_map0(SM),
	store_sm0(SM,Sit,Id,SM_new),
	del_db(support_map0),
	asserta(support_map0(SM_new)).
store_sm0([],[],_,[]).
store_sm0([],Sit,Id,SM_new):-
	store_sm01(Sit,Id,SM_new).
store_sm01([],_,[]).
store_sm01([E|Sit],Id,[[E,[Id]]|SM_new]):-
	store_sm01(Sit,Id,SM_new).
store_sm0([E|SM],Sit,Id,[E_new|SM_new]):-
	store_sm0_sub(E,Sit,Id,E_new,Sit_new),
	store_sm0(SM,Sit_new,Id,SM_new).
store_sm0([E|SM],Sit,Id,[E|SM_new]):-
	store_sm0(SM,Sit,Id,SM_new).
store_sm0_sub([S,Infons],Sit,Id,[S,[Id|Infons]],Sit_new):-
	user:member(S,Sit),
	user:non_member(Id,Infons),
	user:delete(Sit,S,Sit_new).
store_sm0_sub([S,Infons],Sit,Id,[S,Infons],Sit_new):-
	user:member(S,Sit),
	user:delete(Sit,S,Sit_new).

store_sm(Sit,Id,1):-
	support_map1(SM),
	store_sm1(SM,Sit,Id,SM_new),
	del_db(support_map1),
	asserta(support_map1(SM_new)).
store_sm(Sit,Id,2):-
	support_map2(SM),
	store_sm2(SM,Sit,Id,SM_new),
	del_db(support_map2),
	asserta(support_map2(SM_new)).

/* ǡ١ΤμФƿid֤ */
new_id(Type,Id):-
	bb_get(Type,Id),
	Id_next is Id + 1,
	bb_put(Type,Id_next).

/* infonsǡ١νʣ򤱤 */
check_member(Inf,[],-1).
check_member(Inf,[[Id,Inf]|_],Id).
check_member(Inf,[[_,X]|As],Id):-
	check_member(Inf,As,Id).

/* support(E,Inf,Type) :- 
    EϥTypeǥեInf򥵥ݡȤ */
support(E,Inf,0):-
	support0(E,Inf).
support(E,Inf,1):-
	support1(E,Inf).
support(E,Inf,2):-
	support2(E,Inf).

/* support0(E,Inf) :- EեInf򥵥ݡȤƤ */
support0(E,Inf):-
	atom(E),
	get_data(support_map0,E,Infs),!,
	user:member(Id,Infs),
	get_data(infons,Id,Inf).
support1(S,Inf):-
	ground(S),
	get_data(support_map1,S,Infs),!,
	user:member(Id,Infs),
	get_data(infons,Id,Inf).
support1(S,Inf):-
	nonvar(Inf),
	get_data(infons,Id,Inf),!,
	get_data(support_map1,S,Infs),
	user:member(Id,Infs).
support2(S,Inf):-
	ground(S),
	get_data(support_map2,S,Infs),!,
	user:member(Id,Infs),
	get_data(infons,Id,Inf).
support2(S,Inf):-
	nonvar(Inf),
	get_data(infons,Id,Inf),!,
	get_data(support_map2,S,Infs),
	user:member(Id,Infs).

/* get_data(Map_name,Key,Result)
	:- ޥåMap_nameKey򥭡ˤͤ */
get_data(Map_name,Key,Val):-
	Pred=..[Map_name,Contents],
	Pred,!,
	u:assoc(Key,Contents,Val).

/* rs(E) :- Ereasoning situationǤ */
rs(E) :-
	str_order(X),
	user:member(E,X).

/* rule(Id,Rule) :- Ruleϥ롼idIdΥ롼Ǥ */
rule(Id,Rule):-
	get_data(rules,Id,Rule).

/* link(S1,S2) :- S1S2ܤƤ */
link(S1,S2):-
	get_data(s_link,S1,SL),
	user:member(S2,SL).
link(S,nil).

/* get_domain([First,Last,Nes],Dom):- , , ɬܥꥹȤõϰϤ */
get_domain([First,Last,Nes],Dom):-
	get_domain_f(First,Rf),
	get_domain_l(Last,Rl),
	u:intersection([Rf,Rl],Dom),
	u:subset(Nes,Dom).

get_domain_f(nil,All):-
	domain(All).
get_domain_f(First,Rf):-
	get_domain_f1([First],Rf).
get_domain_f1([X|L],[X|Res]):-
	get_data(s_link,X,S),
	u:union([S,L],Tmp),
	get_domain_f1(Tmp,Res).
get_domain_f1(R,R).

get_domain_l(nil,All):-
	domain(All).
get_domain_l(Last,Rl):-
	get_domain_l1([Last],Rl).
get_domain_l1([X|L],[X|Res]):-
	setof(Y,link(Y,X),S),
	u:union([S,L],Tmp),
	get_domain_l1(Tmp,Res).
get_domain_l1(R,R).
